/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.EtchedBorder;

class timer
extends JPanel
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final long VersionNo = 3L;
    private static final int TYPE_TIMER = 0;
    private static final int TYPE_STOPW = 1;
    private static final int TYPE_CLOCK = 2;
    private static final int TYPE_ALARM = 3;
    private transient timerWindow win;
    private Timer time;
    private JPanel textFields;
    private JPanel messageP;
    private JPanel fb;
    private JPanel ap;
    private JPanel tp;
    private JPanel buttons;
    private JTextField hours;
    private JTextField minutes;
    private JTextField seconds;
    private JLabel ampm;
    private JTextField message;
    private JLabel feedback;
    private JCheckBox alarmBox;
    private JCheckBox multiBox;
    private JCheckBox repeatBox;
    private JComboBox typeBox;
    private static final String typeTimer = "Timer";
    private static final String typeStopw = "Stopwatch";
    private static final String typeClock = "Clock";
    private static final String typeAlarm = "Alarm";
    private static final String typeOptns = "(Options)";
    private JButton testAlarm;
    private JButton start;
    private JButton stop;
    private JButton clear;
    private int hourT;
    private int autohourT;
    private int minuteT;
    private int autominuteT;
    private int secondT;
    private int autosecondT;
    private String zero = "0";
    private final String rMessage = "Time Keeper ";
    private String tMessage = "Time Keeper ";
    private int timer = 0;
    private int dots = 0;
    private boolean customAlarm = false;
    private boolean customSnooze = false;
    private boolean customZone = false;
    private boolean customType = false;
    private String alert = "alert";
    private int snoozehour = 0;
    private int snoozemin = 5;
    private int snoozesec = 0;
    private String timezone = "";
    private String timezoneSel = "";
    private int timetype = 0;
    private transient JFrame optionsPanel;
    private JPanel optPanel1 = new JPanel();
    private JPanel optPanel2 = new JPanel();
    private JPanel optPanel3 = new JPanel();
    private JPanel optPanel4 = new JPanel();
    private JPanel optPanel5 = new JPanel();
    private final JLabel optAlarmLabel = new JLabel("Alarm Sound:");
    private final JLabel optSnoozeLabel = new JLabel("Snooze Time:");
    private final JLabel optZoneLabel = new JLabel("Time Zone:");
    private final JLabel optTypeLabel = new JLabel("Time Type:");
    private JCheckBox customiseAlarm = new JCheckBox("Customise");
    private JCheckBox customiseSnooze = new JCheckBox("Customise");
    private JCheckBox customiseZone = new JCheckBox("Customise");
    private JCheckBox customiseType = new JCheckBox("Customise");
    private JButton optUncustomise = new JButton("Uncustomise All");
    private JTextField optAlarm = new JTextField(10);
    private JTextField optSnzeHr = new JTextField(2);
    private JTextField optSnzeMin = new JTextField(2);
    private JTextField optSnzeSec = new JTextField(2);
    private JComboBox optTimezone;
    private JComboBox optTimetype = new JComboBox();
    private JButton optOK = new JButton("OK");
    private JButton optCancel = new JButton("Cancel");

    public timer(timerWindow w, int no) {
        this.setBorder(new EtchedBorder());
        this.tMessage = String.valueOf(this.tMessage) + Integer.toString(no);
        this.win = w;
        this.time = new Timer(1000, new update());
        Calendar rightNow = Calendar.getInstance();
        this.textFields = new JPanel();
        this.messageP = new JPanel();
        this.fb = new JPanel();
        this.ap = new JPanel();
        this.tp = new JPanel();
        this.buttons = new JPanel();
        ImageIcon i = new ImageIcon("soundicon.dat");
        this.testAlarm = new JButton(i);
        this.testAlarm.setPreferredSize(new Dimension(28, 25));
        this.testAlarm.setToolTipText("Test Alarm");
        this.testAlarm.addActionListener(new alertRespond());
        this.hours = new JTextField(this.zero, 2);
        this.minutes = new JTextField(this.zero, 2);
        this.seconds = new JTextField(this.zero, 2);
        this.ampm = new JLabel();
        this.textFields.add(new JLabel("Hr:"));
        this.textFields.add(this.hours);
        this.textFields.add(new JLabel("Min:"));
        this.textFields.add(this.minutes);
        this.textFields.add(new JLabel("Sec:"));
        this.textFields.add(this.seconds);
        this.textFields.add(this.ampm);
        this.message = new JTextField(this.tMessage, 15);
        this.messageP.add(this.message);
        this.alarmBox = new JCheckBox("Play Alarm", true);
        this.multiBox = new JCheckBox("Multi S/S", false);
        this.repeatBox = new JCheckBox("Repeat", false);
        this.typeBox = new JComboBox();
        this.typeBox.addItem(typeTimer);
        this.typeBox.addItem(typeStopw);
        this.typeBox.addItem(typeClock);
        this.typeBox.addItem(typeAlarm);
        this.typeBox.addItem(typeOptns);
        this.typeBox.addActionListener(new typeRespond());
        this.ap.add(this.alarmBox);
        this.ap.add(this.multiBox);
        this.ap.add(this.repeatBox);
        this.tp.add(this.typeBox);
        this.tp.add(this.testAlarm);
        this.feedback = new JLabel();
        this.fb.add(this.feedback);
        this.start = new JButton("Start");
        this.start.addActionListener(new playRespond());
        this.stop = new JButton("Stop");
        this.stop.addActionListener(new pauseRespond());
        this.clear = new JButton("Clear");
        this.clear.addActionListener(new clearRespond());
        this.buttons.add(this.start);
        this.buttons.add(this.stop);
        this.buttons.add(this.clear);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.textFields);
        this.add(this.messageP);
        this.add(this.ap);
        this.add(this.tp);
        this.add(this.fb);
        this.add(this.buttons);
        Object[] timezones = TimeZone.getAvailableIDs();
        Arrays.sort(timezones);
        this.optTimezone = new JComboBox<Object>(timezones);
        TimeZone t = rightNow.getTimeZone();
        this.timezone = t.getID();
        this.timezoneSel = t.getID();
        this.optTimetype.addItem("AM/PM");
        this.optTimetype.addItem("24Hr");
        this.optOK.addActionListener(new optionsPanelRespond());
        this.optCancel.addActionListener(new optionsPanelRespond());
        this.optUncustomise.addActionListener(new optionsPanelRespond());
        this.optPanel1.add(this.optAlarm);
        this.optPanel1.add(new JLabel(".wav"));
        this.optPanel2.add(new JLabel("Hr:"));
        this.optPanel2.add(this.optSnzeHr);
        this.optPanel2.add(new JLabel("Min:"));
        this.optPanel2.add(this.optSnzeMin);
        this.optPanel2.add(new JLabel("Sec:"));
        this.optPanel2.add(this.optSnzeSec);
        this.optPanel3.add(this.optTimezone);
        this.optPanel4.add(this.optTimetype);
        this.optPanel5.add(this.optCancel);
        this.optPanel5.add(this.optOK);
        this.customiseAlarm.addActionListener(new optionsCustomiseRespond());
        this.customiseSnooze.addActionListener(new optionsCustomiseRespond());
        this.customiseZone.addActionListener(new optionsCustomiseRespond());
        this.customiseType.addActionListener(new optionsCustomiseRespond());
        this.optionsPanel = new JFrame();
        this.optionsPanel.setSize(450, 200);
        this.optionsPanel.setDefaultCloseOperation(1);
        GroupLayout gl = new GroupLayout(this.optionsPanel.getContentPane());
        this.optionsPanel.getContentPane().setLayout(gl);
        GroupLayout.SequentialGroup hGroup = gl.createSequentialGroup();
        hGroup.addGroup(gl.createParallelGroup().addComponent(this.optAlarmLabel).addComponent(this.optSnoozeLabel).addComponent(this.optZoneLabel).addComponent(this.optTypeLabel).addGap(1));
        hGroup.addGroup(gl.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.customiseAlarm).addComponent(this.customiseSnooze).addComponent(this.customiseZone).addComponent(this.customiseType).addComponent(this.optUncustomise));
        hGroup.addGroup(gl.createParallelGroup().addComponent(this.optPanel1).addComponent(this.optPanel2).addComponent(this.optPanel3).addComponent(this.optPanel4).addComponent(this.optPanel5));
        gl.setHorizontalGroup(hGroup);
        GroupLayout.SequentialGroup vGroup = gl.createSequentialGroup();
        vGroup.addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.optAlarmLabel).addComponent(this.customiseAlarm).addComponent(this.optPanel1));
        vGroup.addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.optSnoozeLabel).addComponent(this.customiseSnooze).addComponent(this.optPanel2));
        vGroup.addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.optZoneLabel).addComponent(this.customiseZone).addComponent(this.optPanel3));
        vGroup.addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.optTypeLabel).addComponent(this.customiseType).addComponent(this.optPanel4));
        vGroup.addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addGap(1).addComponent(this.optUncustomise).addComponent(this.optPanel5));
        gl.setVerticalGroup(vGroup);
        this.optSetEditable(0, false);
    }

    public String getFeedback() {
        return this.feedback.getText();
    }

    public String getMessage() {
        return this.message.getText();
    }

    public long getSerialUID() {
        return 2L;
    }

    private void systemTimeZone() {
        this.timezone = this.timezoneSel;
        this.optTimezone.setSelectedItem(this.timezone);
    }

    public void prepareSerialise() {
        if (this.time.isRunning()) {
            this.time.stop();
        }
        this.setEntry(true);
        this.feedback.setText("");
        this.dots = 0;
    }

    public void saveTimer(XMLEncoder stream) {
        stream.writeObject(3L);
        stream.writeObject(this.hours.getText());
        stream.writeObject(this.minutes.getText());
        stream.writeObject(this.seconds.getText());
        stream.writeObject(this.message.getText());
        stream.writeObject(this.timer);
        stream.writeObject(this.typeBox.getSelectedIndex());
        stream.writeObject(this.alarmBox.isSelected());
        stream.writeObject(this.multiBox.isSelected());
        stream.writeObject(this.repeatBox.isSelected());
        stream.writeObject(this.customAlarm);
        stream.writeObject(this.customSnooze);
        stream.writeObject(this.customType);
        stream.writeObject(this.customZone);
        stream.writeObject(this.alert);
        stream.writeObject(this.snoozehour);
        stream.writeObject(this.snoozemin);
        stream.writeObject(this.snoozesec);
        stream.writeObject(this.timezone);
        stream.writeObject(this.timetype);
    }

    public void loadTimer(XMLDecoder stream) throws ArrayIndexOutOfBoundsException {
        long versionNo = (Long)stream.readObject();
        this.hours.setText((String)stream.readObject());
        this.minutes.setText((String)stream.readObject());
        this.seconds.setText((String)stream.readObject());
        this.message.setText((String)stream.readObject());
        this.timer = (Integer)stream.readObject();
        this.typeBox.setSelectedIndex((Integer)stream.readObject());
        this.alarmBox.setSelected((Boolean)stream.readObject());
        this.multiBox.setSelected((Boolean)stream.readObject());
        this.repeatBox.setSelected((Boolean)stream.readObject());
        this.customAlarm = (Boolean)stream.readObject();
        this.customSnooze = (Boolean)stream.readObject();
        this.customType = (Boolean)stream.readObject();
        this.customZone = (Boolean)stream.readObject();
        this.alert = (String)stream.readObject();
        this.snoozehour = (Integer)stream.readObject();
        this.snoozemin = (Integer)stream.readObject();
        this.snoozesec = (Integer)stream.readObject();
        this.timezone = (String)stream.readObject();
        this.timetype = (Integer)stream.readObject();
    }

    private void startTimer() {
        this.feedbackUser(0);
        this.setEntry(false);
        try {
            this.secondT = Integer.parseInt(this.seconds.getText());
            if (this.secondT > 59) {
                throw new TimeAboveException(3);
            }
            this.minuteT = Integer.parseInt(this.minutes.getText());
            if (this.minuteT > 59) {
                throw new TimeAboveException(4);
            }
            this.hourT = Integer.parseInt(this.hours.getText());
            if (this.hourT > 12 && this.timer == 3 && (this.customType && this.timetype == 0 || this.win.getTimeType() == 0)) {
                throw new TimeAboveException(5);
            }
            if (this.hourT > 23 && this.timer == 3 && (this.customType && this.timetype == 1 || this.win.getTimeType() == 1)) {
                throw new TimeAboveException(7);
            }
            if (this.timer == 0 && this.repeatBox.isSelected()) {
                this.autosecondT = this.secondT;
                this.autominuteT = this.minuteT;
                this.autohourT = this.hourT;
            }
            this.time.start();
            if (this.timer == 3) {
                this.feedbackUser(6);
            }
            this.win.runInc();
        }
        catch (NumberFormatException e) {
            this.feedbackUser(1);
            this.clearTimer();
            this.setEntry(true);
        }
        catch (TimeAboveException f) {
            this.feedbackUser(f.getFN());
            this.clearTimer();
            this.setEntry(true);
        }
    }

    private void timeDown() {
        if (this.time.isRunning()) {
            if (this.secondT > 0) {
                --this.secondT;
            } else if (this.secondT == 0) {
                if (this.minuteT > 0) {
                    --this.minuteT;
                    this.secondT = 59;
                } else if (this.minuteT == 0) {
                    if (this.hourT > 0) {
                        --this.hourT;
                        this.minuteT = 59;
                        this.secondT = 59;
                    } else if (this.hourT == 0) {
                        this.alert();
                    }
                }
            }
        }
    }

    private void timeUp() {
        if (this.time.isRunning()) {
            if (this.secondT < 59) {
                ++this.secondT;
            } else if (this.secondT == 59) {
                if (this.minuteT < 59) {
                    ++this.minuteT;
                    this.secondT = 0;
                } else if (this.minuteT == 59) {
                    ++this.hourT;
                    this.minuteT = 0;
                    this.secondT = 0;
                }
            }
        }
    }

    private void clock() {
        Calendar rightNow = Calendar.getInstance();
        if (this.customZone) {
            TimeZone t = TimeZone.getTimeZone(this.timezone);
            rightNow.setTimeZone(t);
        }
        this.hourT = this.customType && this.timetype == 1 || !this.customType && this.win.getTimeType() == 1 ? rightNow.get(11) : rightNow.get(10);
        this.minuteT = rightNow.get(12);
        this.secondT = rightNow.get(13);
        if (this.customType && this.timetype == 0 || !this.customType && this.win.getTimeType() == 0) {
            if (this.hourT == 0) {
                this.hourT = 12;
            }
            if (rightNow.get(9) == 0) {
                this.ampm.setText("AM");
            } else {
                this.ampm.setText("PM");
            }
        }
    }

    private void alarm() {
        Calendar rightNow = Calendar.getInstance();
        if (this.customZone) {
            TimeZone t = TimeZone.getTimeZone(this.timezone);
            rightNow.setTimeZone(t);
        }
        if (this.customType && this.timetype == 0 || !this.customType && this.win.getTimeType() == 0) {
            if (this.hourT == 12) {
                this.hourT = 0;
            }
            if (rightNow.get(10) == this.hourT && rightNow.get(12) == this.minuteT && rightNow.get(13) == this.secondT) {
                this.alert();
            }
            if (this.hourT == 0) {
                this.hourT = 12;
            }
        } else if ((this.customType && this.timetype == 1 || !this.customType && this.win.getTimeType() == 1) && rightNow.get(11) == this.hourT && rightNow.get(12) == this.minuteT && rightNow.get(13) == this.secondT) {
            this.alert();
        }
    }

    private void snooze() {
        if (this.timer == 0) {
            if (this.customSnooze) {
                this.secondT = this.snoozesec;
                this.minuteT = this.snoozemin;
                this.hourT = this.snoozehour;
            } else {
                this.secondT = this.win.getSnoozeSec();
                this.minuteT = this.win.getSnoozeMin();
                this.hourT = this.win.getSnoozeHour();
            }
        } else if (this.timer == 3) {
            Calendar alarmTime = Calendar.getInstance();
            if (this.customType && this.timetype == 1 || !this.customType && this.win.getTimeType() == 1) {
                alarmTime.set(11, this.hourT);
            } else {
                alarmTime.set(11, this.hourT);
            }
            alarmTime.set(12, this.minuteT);
            alarmTime.set(13, this.secondT);
            if (this.customSnooze) {
                alarmTime.add(13, this.snoozesec);
                alarmTime.add(12, this.snoozemin);
                alarmTime.add(10, this.snoozehour);
                this.secondT = alarmTime.get(13);
                this.minuteT = alarmTime.get(12);
                this.hourT = alarmTime.get(10);
            } else {
                alarmTime.add(13, this.win.getSnoozeSec());
                alarmTime.add(12, this.win.getSnoozeMin());
                alarmTime.add(10, this.win.getSnoozeHour());
                this.secondT = alarmTime.get(13);
                this.minuteT = alarmTime.get(12);
                this.hourT = alarmTime.get(10);
            }
        }
        this.setEntry(false);
        this.time.start();
        if (this.timer == 3) {
            this.feedbackUser(6);
        }
    }

    private void stopTimer() {
        if (this.time.isRunning()) {
            this.time.stop();
        }
        this.setEntry(true);
        this.feedback.setText("");
        this.ampm.setText("");
        this.dots = 0;
        this.win.runDec();
        this.win.refresh();
    }

    private void clearTimer() {
        this.hours.setText(this.zero);
        this.minutes.setText(this.zero);
        this.seconds.setText(this.zero);
    }

    private void alert() {
        if (this.timer == 0 && this.repeatBox.isSelected()) {
            this.hourT = this.autohourT;
            this.minuteT = this.autominuteT;
            this.secondT = this.autosecondT;
            if (this.alarmBox.isSelected() && this.customAlarm) {
                this.win.alert(this, this.alert);
            } else if (this.alarmBox.isSelected() && !this.customAlarm) {
                this.win.alert(this);
            }
        } else {
            this.stopTimer();
            if (this.alarmBox.isSelected() && this.customAlarm) {
                this.win.alert(this, this.alert);
            } else if (this.alarmBox.isSelected() && !this.customAlarm) {
                this.win.alert(this);
            }
            Object[] options = new Object[]{"OK", "SNOOZE"};
            int x = JOptionPane.showOptionDialog(null, this.message.getText(), "Time's Up!", -1, 1, null, options, options[0]);
            if (x == 1) {
                this.snooze();
            }
            this.clearTimer();
        }
    }

    public void testAlarm() {
        if (this.customAlarm) {
            this.win.alert(this, this.alert);
        } else if (!this.customAlarm) {
            this.win.alert(this);
        }
    }

    private void setEntry(boolean j) {
        this.hours.setEditable(j);
        this.minutes.setEditable(j);
        this.seconds.setEditable(j);
        this.message.setEditable(j);
        this.typeBox.setEnabled(j);
    }

    public void newtimer(int no) {
        if (this.time.isRunning()) {
            this.stopTimer();
        }
        this.clearTimer();
        this.message.setText("Time Keeper " + no);
        this.timer = 0;
        this.alarmBox.setSelected(true);
        this.multiBox.setSelected(false);
        this.repeatBox.setSelected(false);
        this.typeBox.setSelectedIndex(0);
        this.customAlarm = false;
        this.customSnooze = false;
        this.customZone = false;
        this.customType = false;
        this.alert = "alert";
        this.snoozehour = 0;
        this.snoozemin = 5;
        this.snoozesec = 0;
        this.timetype = 0;
        Calendar rightNow = Calendar.getInstance();
        TimeZone t = rightNow.getTimeZone();
        this.timezone = t.getID();
    }

    public void multi() {
        if (this.multiBox.isSelected() && this.time.isRunning()) {
            this.stopTimer();
        } else if (this.multiBox.isSelected()) {
            this.startTimer();
        }
    }

    public void allStart() {
        if (!this.time.isRunning()) {
            this.startTimer();
        }
    }

    public void allStop() {
        if (this.time.isRunning()) {
            this.stopTimer();
        }
    }

    public void feedbackUser(int n) {
        if (n == 0) {
            this.feedback.setText("");
        } else if (n == 1) {
            this.feedback.setText("Incorrect Format!");
        } else if (n == 2) {
            this.feedback.setText("No Sound!");
        } else if (n == 3) {
            this.feedback.setText("Seconds should be 59 or Less!");
        } else if (n == 4) {
            this.feedback.setText("Minutes should be 59 or Less!");
        } else if (n == 5) {
            this.feedback.setText("Hours should be 12 or Less!");
        } else if (n == 6) {
            this.feedback.setText("Alarm Set!");
        } else if (n == 7) {
            this.feedback.setText("Hours should be 23 or Less!");
        }
    }

    private void feedbackDotsSW() {
        if (this.dots == 0) {
            this.feedback.setText("     ");
        } else if (this.dots == 1 || this.dots == 9) {
            this.feedback.setText(">    ");
        } else if (this.dots == 2 || this.dots == 8) {
            this.feedback.setText(">>   ");
        } else if (this.dots == 3 || this.dots == 7) {
            this.feedback.setText(">>>  ");
        } else if (this.dots == 4 || this.dots == 6) {
            this.feedback.setText(">>>> ");
        } else if (this.dots == 5) {
            this.feedback.setText(">>>>>");
        }
        ++this.dots;
        if (this.dots == 10) {
            this.dots = 0;
        }
    }

    private void feedbackDotsTM() {
        if (this.dots == 0) {
            this.feedback.setText("     ");
        } else if (this.dots == 1 || this.dots == 9) {
            this.feedback.setText("    <");
        } else if (this.dots == 2 || this.dots == 8) {
            this.feedback.setText("   <<");
        } else if (this.dots == 3 || this.dots == 7) {
            this.feedback.setText("  <<<");
        } else if (this.dots == 4 || this.dots == 6) {
            this.feedback.setText(" <<<<");
        } else if (this.dots == 5) {
            this.feedback.setText("<<<<<");
        }
        ++this.dots;
        if (this.dots == 10) {
            this.dots = 0;
        }
    }

    private void feedbackDotsCL() {
        if (this.dots == 0) {
            this.feedback.setText("     ");
        } else if (this.dots == 1 || this.dots == 9) {
            this.feedback.setText("  O  ");
        } else if (this.dots == 2 || this.dots == 8) {
            this.feedback.setText(" O O ");
        } else if (this.dots == 3 || this.dots == 7) {
            this.feedback.setText("O O O");
        } else if (this.dots == 4 || this.dots == 6) {
            this.feedback.setText("OO OO");
        } else if (this.dots == 5) {
            this.feedback.setText("OOOOO");
        }
        ++this.dots;
        if (this.dots == 10) {
            this.dots = 0;
        }
    }

    private void optSetEditable(int no, boolean t) {
        if (no == 1 || no == 0) {
            this.optAlarm.setEditable(t);
        }
        if (no == 2 || no == 0) {
            this.optSnzeHr.setEditable(t);
            this.optSnzeMin.setEditable(t);
            this.optSnzeSec.setEditable(t);
        }
        if (no == 3 || no == 0) {
            this.optTimezone.setEnabled(t);
        }
        if (no == 4 || no == 0) {
            this.optTimetype.setEnabled(t);
        }
    }

    private boolean optGetEditable(int no) {
        if (no == 1) {
            return this.optAlarm.isEditable();
        }
        if (no == 2) {
            return this.optSnzeHr.isEditable();
        }
        if (no == 3) {
            return this.optTimezone.isEnabled();
        }
        if (no == 4) {
            return this.optTimetype.isEnabled();
        }
        return false;
    }

    class update
    implements ActionListener {
        update() {
        }

        public void actionPerformed(ActionEvent e) {
            if (timer.this.timer == 0) {
                timer.this.timeDown();
            } else if (timer.this.timer == 1) {
                timer.this.timeUp();
            } else if (timer.this.timer == 2) {
                timer.this.clock();
            } else if (timer.this.timer == 3) {
                timer.this.alarm();
            }
            timer.this.hours.setText(Integer.toString(timer.this.hourT));
            timer.this.minutes.setText(Integer.toString(timer.this.minuteT));
            timer.this.seconds.setText(Integer.toString(timer.this.secondT));
            if (timer.this.timer == 1) {
                timer.this.feedbackDotsSW();
            } else if (timer.this.timer == 0) {
                timer.this.feedbackDotsTM();
            } else if (timer.this.timer == 2) {
                timer.this.feedbackDotsCL();
            }
            timer.this.win.refresh();
        }
    }

    class playRespond
    implements ActionListener {
        playRespond() {
        }

        public void actionPerformed(ActionEvent e) {
            timer.this.startTimer();
        }
    }

    class pauseRespond
    implements ActionListener {
        pauseRespond() {
        }

        public void actionPerformed(ActionEvent e) {
            timer.this.stopTimer();
        }
    }

    class bothRespond
    implements ActionListener {
        bothRespond() {
        }

        public void actionPerformed(ActionEvent e) {
            if (timer.this.time.isRunning()) {
                timer.this.stopTimer();
            } else {
                timer.this.startTimer();
            }
        }
    }

    class clearRespond
    implements ActionListener {
        clearRespond() {
        }

        public void actionPerformed(ActionEvent e) {
            if (timer.this.time.isRunning()) {
                timer.this.stopTimer();
            }
            timer.this.clearTimer();
        }
    }

    class typeRespond
    implements ActionListener {
        typeRespond() {
        }

        public void actionPerformed(ActionEvent e) {
            String z = (String)timer.this.typeBox.getSelectedItem();
            if (z.equals(timer.typeTimer)) {
                timer.this.timer = 0;
            } else if (z.equals(timer.typeStopw)) {
                timer.this.timer = 1;
            } else if (z.equals(timer.typeClock)) {
                timer.this.timer = 2;
            } else if (z.equals(timer.typeAlarm)) {
                timer.this.timer = 3;
            } else if (z.equals(timer.typeOptns)) {
                this.optionsRespond();
            }
            if (timer.this.timer == 0 && !timer.this.repeatBox.isVisible()) {
                timer.this.repeatBox.setVisible(true);
            }
            if (timer.this.timer != 0 && timer.this.repeatBox.isVisible()) {
                timer.this.repeatBox.setVisible(false);
            }
            if (!(timer.this.timer != 0 && timer.this.timer != 3 || timer.this.alarmBox.isVisible())) {
                timer.this.alarmBox.setVisible(true);
            } else if (timer.this.timer != 0 && timer.this.timer != 3 && timer.this.alarmBox.isVisible()) {
                timer.this.alarmBox.setVisible(false);
            }
        }

        public void optionsRespond() {
            timer.this.customiseAlarm.setSelected(timer.this.customAlarm);
            if (timer.this.customiseAlarm.isSelected() && !timer.this.optGetEditable(1)) {
                timer.this.optSetEditable(1, true);
            } else if (!timer.this.customiseAlarm.isSelected() && timer.this.optGetEditable(1)) {
                timer.this.optSetEditable(1, false);
            }
            timer.this.customiseSnooze.setSelected(timer.this.customSnooze);
            if (timer.this.customiseSnooze.isSelected() && !timer.this.optGetEditable(2)) {
                timer.this.optSetEditable(2, true);
            } else if (!timer.this.customiseSnooze.isSelected() && timer.this.optGetEditable(2)) {
                timer.this.optSetEditable(2, false);
            }
            timer.this.customiseZone.setSelected(timer.this.customZone);
            if (timer.this.customiseZone.isSelected() && !timer.this.optGetEditable(3)) {
                timer.this.optSetEditable(3, true);
            } else if (!timer.this.customiseZone.isSelected() && timer.this.optGetEditable(3)) {
                timer.this.optSetEditable(3, false);
            }
            timer.this.customiseType.setSelected(timer.this.customType);
            if (timer.this.customiseType.isSelected() && !timer.this.optGetEditable(4)) {
                timer.this.optSetEditable(4, true);
            } else if (!timer.this.customiseType.isSelected() && timer.this.optGetEditable(4)) {
                timer.this.optSetEditable(4, false);
            }
            timer.this.optAlarm.setText(timer.this.alert);
            timer.this.optSnzeHr.setText(Integer.toString(timer.this.snoozehour));
            timer.this.optSnzeMin.setText(Integer.toString(timer.this.snoozemin));
            timer.this.optSnzeSec.setText(Integer.toString(timer.this.snoozesec));
            timer.this.optTimezone.setSelectedItem(timer.this.timezone);
            timer.this.optTimetype.setSelectedIndex(timer.this.timetype);
            timer.this.optionsPanel.setTitle(String.valueOf(timer.this.message.getText()) + " Options");
            timer.this.optionsPanel.setVisible(true);
            timer.this.typeBox.setSelectedIndex(timer.this.timer);
        }
    }

    class optionsPanelRespond
    implements ActionListener {
        optionsPanelRespond() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == timer.this.optOK) {
                if (timer.this.customZone && !timer.this.customiseZone.isSelected()) {
                    timer.this.systemTimeZone();
                }
                timer.this.customAlarm = timer.this.customiseAlarm.isSelected();
                timer.this.customSnooze = timer.this.customiseSnooze.isSelected();
                timer.this.customZone = timer.this.customiseZone.isSelected();
                timer.this.customType = timer.this.customiseType.isSelected();
                timer.this.alert = timer.this.optAlarm.getText();
                try {
                    timer.this.snoozehour = Integer.parseInt(timer.this.optSnzeHr.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    timer.this.snoozemin = Integer.parseInt(timer.this.optSnzeMin.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    timer.this.snoozesec = Integer.parseInt(timer.this.optSnzeSec.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                timer.this.timezone = (String)timer.this.optTimezone.getSelectedItem();
                timer.this.timetype = timer.this.optTimetype.getSelectedIndex();
                timer.this.optionsPanel.setVisible(false);
            } else if (e.getSource() == timer.this.optCancel) {
                timer.this.optionsPanel.setVisible(false);
            } else if (e.getSource() == timer.this.optUncustomise) {
                timer.this.customiseAlarm.setSelected(false);
                timer.this.customiseSnooze.setSelected(false);
                timer.this.customiseZone.setSelected(false);
                timer.this.customiseType.setSelected(false);
                timer.this.optSetEditable(0, false);
            }
        }
    }

    class optionsCustomiseRespond
    implements ActionListener {
        optionsCustomiseRespond() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == timer.this.customiseAlarm) {
                if (timer.this.customiseAlarm.isSelected()) {
                    timer.this.optSetEditable(1, true);
                } else {
                    timer.this.optSetEditable(1, false);
                }
            } else if (e.getSource() == timer.this.customiseSnooze) {
                if (timer.this.customiseSnooze.isSelected()) {
                    timer.this.optSetEditable(2, true);
                } else {
                    timer.this.optSetEditable(2, false);
                }
            } else if (e.getSource() == timer.this.customiseZone) {
                if (timer.this.customiseZone.isSelected()) {
                    timer.this.optSetEditable(3, true);
                } else {
                    timer.this.optSetEditable(3, false);
                }
            } else if (e.getSource() == timer.this.customiseType) {
                if (timer.this.customiseType.isSelected()) {
                    timer.this.optSetEditable(4, true);
                } else {
                    timer.this.optSetEditable(4, false);
                }
            }
        }
    }

    class alertRespond
    implements ActionListener {
        alertRespond() {
        }

        public void actionPerformed(ActionEvent e) {
            timer.this.testAlarm();
        }
    }
}

